#include "stm32f10x.h"
#include "STM32_init.h"
#include "i2c.h"
#include <stdio.h>

//------------------------------------------------------------------------------
 
void InitAll(void);
void STM32_Init (void);

void TIM2_IRQHandler (void);

void USART1_IRQHandler (void);

int main( void) 
	{
 	uint16_t i = 1;
	uint16_t start_cnt = 0;

	InitAll();

	printf("\rReset... STM32 On-Line\r");

	start_cnt = I2C_EE_ByteRead(0);
	if (start_cnt > 10)
		{
		for (i=1;i<start_cnt+1;i++) I2C_EE_ByteWrite(0xFF, i);
		I2C_EE_ByteWrite(0, 0);
		}
		else 
			{
			start_cnt++;
			I2C_EE_ByteWrite(start_cnt, 0);
			I2C_EE_ByteWrite(start_cnt, start_cnt);
			}
	
	printf("\rEEPROM Dump Start\r");
		
	for (i=0;i<257;i++) {USART_SendData(USART1, I2C_EE_ByteRead(i));}  
	
	printf("\rEEPROM Dump Complete\r");
	
	while(1) {}; 
  	}
 
//------------------------------------------------------------------------------
 
void InitAll( void) 
	{
  	STM32_Init ();

	I2C_Configuration();
	}
 
//------------------------------------------------------------------------------

unsigned int msec5_cnt;
unsigned char led_bright_cnt;
unsigned char led_cnt;

void TIM2_IRQHandler (void)
	{
	if (TIM2->SR & TIM_SR_UIF)   
		{
		TIM2->SR &= ~TIM_SR_UIF;
		
		if (++msec5_cnt == 125)
			{
			msec5_cnt = 0;
			++led_bright_cnt; 
			}
		
		if (++led_cnt < led_bright_cnt) GPIO_ResetBits(GPIOC, GPIO_Pin_8);
			else GPIO_SetBits(GPIOC, GPIO_Pin_8);
		}
	}

int sendchar (int data)
	{
	uint32_t i = 10000;
	
	USART_SendData(USART1, data);
	while (--i) __NOP();
	return 0;
	}
//------------------------------------------------------------------------------


